require( "quest/m2_fitness/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function flo_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_aerobics_activity_round") < 1 then
		run_super_conversation(flo, "quip_fitness_A");
	elseif game:Get("mg_aerobics_activity_round") < 2 then
		run_super_conversation(flo, "conv_fitness_B");
	elseif game:Get("mg_aerobics_activity_round") >= 2 and not quest_complete("use_cake_instructions") then
		run_super_conversation(flo, "quip_fitness_C");
	elseif not quest_complete("cake") then
		run_super_conversation(flo, "quip_fitness_D");
	else
		run_super_conversation(flo, "quip_flo_general");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		
		prepare_actor_text(actor, flo_text_spec);
		
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		actor:FaceNow(DIR.E);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "mg_aerobics" then
			actor:JumpToNamedPoint("flo");
			wait_fade();
			if game:Get("mg_aerobics_activity_round") <= 1 then
				run_super_conversation(actor, "conv_fitness_not_done");
			elseif game:Get("completed_aerobics") < 1 and game:Get("mg_aerobics_activity_round") > 1 then
				game:Set("completed_aerobics", 1);
				run_super_conversation(scene.JO, "conv_done");
				complete_quest("pass_aerobics");
				wait_subscene();
			end
		else
			actor:JumpToNamedPoint("sunnyside");
			actor:WalkTo("flo");
			if game:Get("first_time_fitness") < 1 then
				game:Set("first_time_fitness", 1);
				wait_walkto();
				actor:Face(DIR.E);
				coroutine.yield(RESUME.ON_CLICK);
				run_super_conversation(actor, "conv_fitness_intro");
				add_quest("pass_aerobics");
			else
				wait_walkto();
				actor:Face(DIR.E);
				-- say some reentry text
				if game:Get("mg_aerobics_activity_round") < 1 then
					run_super_conversation(actor, "conv_fitness_reentry_A");
				elseif game:Get("mg_aerobics_activity_round") == 1 then
					run_super_conversation(actor, "conv_fitness_reentry_B");
				else
					run_super_conversation(actor, "conv_fitness_reentry_C");
				end
			end;
		end;
		
		
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(flo_conv);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function jo_conv(flo, jo)
	flo:SetMode(MODE.CUTSCENE);
	if quest_complete("use_cake_instructions") then	--click on Jo after already using the VCR.
		run_super_conversation(flo, "conv_jo_E");
	elseif game:Get("mg_aerobics_activity_round") >= 2 and game:Get("clicked_VCR") >= 1 then	--click on Jo after finishing 6 routines, and already having clicked on the VCR
		run_super_conversation(flo, "conv_jo_D");
	elseif game:Get("mg_aerobics_activity_round") >= 2 and game:Get("clicked_VCR") < 1 then	--click on Jo after playing aerobics activity, but not clicked on VCR yet.
		run_super_conversation(flo, "conv_jo_C");
	elseif game:Get("mg_aerobics_activity_round") == 1 then	--click on Jo. Already started aerobics activity, but not finished 6 routines.
		run_super_conversation(flo, "conv_jo_B");
	elseif game:Get("mg_aerobics_activity_round") < 1 then		--click on Jo before playing aerobics activity
		run_super_conversation(flo, "conv_jo_A");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

jo_anim_table =
{
	"anim/jo/stand",
	"anim/jo/talkw",
};

function use_video_on_jo(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_aerobics_activity_round") < 2 then
		run_super_conversation(flo, "quip_video_A");
		game:ClearInvUsage();
		goto_scene(flo, "mg_aerobics");
	elseif not quest_complete("use_cake_instructions") then
		run_super_conversation(flo, "quip_video_B");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

jo_spec = 
{
	name = "JO";
	halo = "quest/objects/jow";
	anim = jo_anim_table;
	
	command = function(actor)
		actor:JumpToNamedPoint("jo");
		prepare_actor_text(actor, jo_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive = function(flo, jo)
		flo:FaceActor(jo);
		flo:StartProc(jo_conv);
	end;
	
	on_use_inv = function(item, flo, jo)
		flo:FaceActor(jo);
		
		if item == "vhstape" then
			flo:StartProc(use_video_on_jo);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
	
};

function look_at_students(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_aerobics_activity_round") < 2 then
		run_super_conversation(flo, "quip_stretch_A");
	else
		run_super_conversation(flo, "quip_stretch_B");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

aerobics_student1_spec = 
{
	name = "AEROBICS_STUDENT1";
	halo = "quest/objects/aerobics_student1";
	gfx = { anim = "anim/aerobics_student1/stand" };
	
	command = function(actor)
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:JumpToNamedPoint("aerobics_student1");
		if game:Get("mg_aerobics_activity_round") < 2 then
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(look_at_students);
	end;
};

aerobics_student2_spec = 
{
	name = "AEROBICS_STUDENT2";
	halo = "quest/objects/aerobics_student2";
	gfx = { anim = "anim/aerobics_student2/stand" };
	
	command = function(actor)
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:JumpToNamedPoint("aerobics_student2");
		if game:Get("mg_aerobics_activity_round") < 2 then
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(look_at_students);
	end;
};

aerobics_student3_spec = 
{
	name = "AEROBICS_STUDENT3";
	halo = "quest/objects/aerobics_student3";
	gfx = { anim = "anim/aerobics_student3/stand" };
	
	command = function(actor)
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:JumpToNamedPoint("aerobics_student3");
		if game:Get("mg_aerobics_activity_round") < 2 then
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(look_at_students);
	end;
};

function talk_to_body_builder(flo)
	flo:SetMode(MODE.CUTSCENE);
	local body_builder_conv_num = game:Get("body_builder_conv_num");
	local body_builder_conv = ""
	
	if body_builder_conv_num < 1 then
		body_builder_conv_num = 1;
	end
	
	if body_builder_conv_num == 1 then
		body_builder_conv = "conv_bodybuilder_A";
	elseif body_builder_conv_num == 2 then
		body_builder_conv = "conv_bodybuilder_B";
	else
		body_builder_conv = "conv_bodybuilder_C";
	end
	
	run_super_conversation(flo, body_builder_conv);
	
	body_builder_conv_num = body_builder_conv_num + 1;
	
	if body_builder_conv_num > 3 then
		body_builder_conv_num = 1;
	end
	
	game:Set("body_builder_conv_num", body_builder_conv_num);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

bodybuilder_anim_table = 
{
	"anim/bodybuilder/stand",
	"anim/bodybuilder/talk",
};

bodybuilder_spec = 
{
	name = "BODY";
	halo = "quest/objects/bodybuilder";
	anim = bodybuilder_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, bodybuilder_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:JumpToNamedPoint("bodybuilder");
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor)
		flo:StartProc(talk_to_body_builder);
	end;
};

function gotosunnyside(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("mg_aerobics_activity_round") == 1 then
		run_super_conversation(flo, "conv_fitness_exit");
	end;
	
	flo:WalkTo("sunnyside");
	wait_walkto();
	goto_scene(flo, "m2_sunnyside");
end

to_sunnyside_spec = 
{
	name = "TO_SUNNYSIDE";
	halo = "door";
	cursor = "cursor_arrow_w";
	goto_fn = gotosunnyside;
}

function click_entertainment(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("entertainment");
	wait_walkto();
	
	if quest_complete("use_cake_instructions") then
		run_super_conversation(flo, "quip_vcr_C");
	else
		if BAG_INV:CheckInventory("vhstape") == false then
			run_super_conversation(flo, "quip_vcr_A");
		else 
			run_super_conversation(flo, "quip_vcr_B");
		end
		
		if not quest_added("info_vcr") then
			add_quest("info_vcr");
		end
	end
	
	flo:WalkTo("flo");
	wait_walkto();
	flo:Face(DIR.E);
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

function entertainment_use_vhs(flo)
	flo:SetMode(MODE.CUTSCENE);

	if game:Get("mg_aerobics_activity_round") < 2 then	--click on Jo. Already started aerobics activity, but not finished 6 routines.
		run_super_conversation(flo, "quip_video_C");
		game:ClearInvUsage();
		goto_scene(flo, "mg_aerobics");
	elseif game:Get("mg_aerobics_activity_round") >= 2 then	--finished aerobics
		run_super_conversation(flo, "quip_video_D");
		flo:WalkTo("entertainment");
		wait_walkto();
		game:ClearInvUsage();
		scene:ChainToSubScene("m2_vcr");
		wait_subscene();
		
		if not quest_complete("use_cake_instructions") then
			complete_quest("use_cake_instructions", false);
			if quest_added("info_vcr") then
				complete_quest("info_vcr", false);
			end
			add_quest("info_cake_code");
			wait_subscene();
			
			flo:WalkTo("flo");
			wait_walkto();
			flo:Face(DIR.E);
			run_super_conversation(flo, "quip_video_done");
			flo:SetMode(MODE.FOLLOWCLICKS);
		else
			flo:WalkTo("flo");
			wait_walkto();
			flo:Face(DIR.E);
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	else
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end;

entertainment_spec = 
{
	name = "ENTERTAINMENT";
	halo = "entertainment";
	gfx = { image = "entertainment" };

	command = function(actor)
		--actor:SetPointAtCursor("cursor");
	end;
	
	on_arrive = function(flo, entertainment)
		flo:StartProc(click_entertainment);
	end;
	
	on_use_inv = function(item, flo, entertainment)
		--flo:FaceActor(entertainment);
		
		if item == "vhstape" then
			flo:StartProc(entertainment_use_vhs);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

barbell_conv = false;
barbell_spec = 
{
	name = "BARBELL";
	halo = "barbell";
	--gfx = { image = "rightcounter" };
	
	command = function(actor)
		actor:SetDepthValue(400);
	end;
	
	on_arrive = function(flo, actor)
		if barbell_conv == false then
			convproc("FLO", "quip_barbells_A");
			barbell_conv = true;
		else
			convproc("FLO", "quip_barbells_B");
			barbell_conv = false;
		end
	end;
};

bike_conv = false;
bike_spec = 
{
	name = "BIKE";
	halo = "bike";
	--gfx = { image = "rightcounter" };
	
	command = function(actor)
		actor:SetDepthValue(400);
	end;
	
	on_arrive = function(flo, actor)
		if bike_conv == false then
			convproc("FLO", "quip_bike_A");
			bike_conv = true;
		else
			convproc("FLO", "quip_bike_B");
			bike_conv = false;
		end
	end;
};

function gotoaerobics(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	
	if game:Get("mg_aerobics_activity_round") < 1 then
		run_super_conversation(flo, "quip_fitness_start");
	elseif game:Get("mg_aerobics_activity_round") > 2 then
		run_super_conversation(flo, "quip_fitness_continue_A");
	else
		run_super_conversation(flo, "quip_fitness_continue_B");
	end
	--flo:WalkTo("sunnyside");
	--wait_walkto();
	goto_scene(flo, "mg_aerobics");
end

to_aerobics_spec = 
{
	name = "TO_AEROBICS";
	halo = "to_aerobics";
	cursor = "cursor_arrow_n";
	depth = 200;
	goto_fn = gotoaerobics;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petshopmusic.ogg", true);
		scene:SetRoomScale(300, 500, 0.93, 0.93);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			--game:Set("first_time_fitness", 0);
			--game:Set("mg_aerobics_activity_round", 2);
			--BAG_INV:AddInventory(inv_desc_vhstape);
		end
		
		spawn_nav_arrow(to_sunnyside_spec);
		if game:Get("mg_aerobics_activity_round") < 2 then
			spawn_nav_arrow(to_aerobics_spec);
		end
		
		game:SetString("map_position", "m2_fitness");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "weightrack1", 400 },

		{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		jo_spec,
		aerobics_student1_spec,
		aerobics_student2_spec,
		aerobics_student3_spec,
		bodybuilder_spec,
		
		entertainment_spec,
		
		bike_spec,
		barbell_spec,
		
		scene_setup,
		flo_spec, -- the main actor
	};
};
